Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.SqlClient
Imports System.Drawing.Imaging
Imports System.IO

Public Class PhotoDB
    Public Shared ReadOnly Property ConnectionString() As String
        Get
            Return ConfigurationManager.ConnectionStrings("SqlServerConnectionString").ConnectionString
        End Get
    End Property

    Public Shared Function InsertCollection(ByVal pc As PhotoCollection) As Boolean

        Try

            Dim conn As New SqlConnection()
            Dim cmd As New SqlCommand()
            conn.ConnectionString = PhotoDB.ConnectionString
            cmd.Connection = conn
            conn.Open()
            cmd.CommandType = CommandType.StoredProcedure
            cmd.CommandText = "add_collection"

            ' Utwrz SqlParameter dla kadego parametru procedury skadowanej.
            Dim nameParam As New SqlParameter("@name", pc.name)
            Dim descParam As New SqlParameter("@desc", pc.description)
            cmd.Parameters.Add(nameParam)
            cmd.Parameters.Add(descParam)

            cmd.ExecuteNonQuery()

            Return True

        Catch ex As Exception


            Throw (ex)

        End Try

    End Function

    Public Shared Function InsertPhoto(ByVal p As Photo) As Boolean
        Try
            'Deklarujemy obiekty dostpu do danych
            Dim conn As New SqlConnection()
            Dim cmd As New SqlCommand()
            'przypisanie odpowiedniego lancucha poloczenia z baza danych
            conn.ConnectionString = PhotoDB.ConnectionString
            cmd.Connection = conn
            conn.Open()
            cmd.CommandType = CommandType.StoredProcedure
            cmd.CommandText = "add_photo"
            ' Tworzymy nowy obiekt SqlParameter dla kazdego parametru procedury wbudowanej
            Dim idParam As New SqlParameter("@path", p.Filepath)
            Dim cParam As New SqlParameter("@collectionID", p.CollectionID)
            Dim nameParam As New SqlParameter("@name", p.Name)
            Dim descParam As New SqlParameter("@desc", p.Description)
            ' Dodajemy kazdy z parametrow do obiektu SqlCommand
            cmd.Parameters.Add(cParam)
            cmd.Parameters.Add(idParam)
            cmd.Parameters.Add(nameParam)
            cmd.Parameters.Add(descParam)
            cmd.ExecuteNonQuery()

            Return True

        Catch ex As Exception
            Throw (ex)
        End Try
    End Function

    Public Shared Function GetFirstImage(ByVal CollectionID) As String

        Try

            Dim conn As New SqlConnection()
            Dim cmd As New SqlCommand()

            conn.ConnectionString = PhotoDB.ConnectionString
            cmd.Connection = conn
            cmd.CommandType = CommandType.StoredProcedure
            cmd.CommandText = "get_first_photo"

            Dim idParam As New SqlParameter("@collectionID", CollectionID)
            cmd.Parameters.Add(idParam)


            Dim result As Object
            Dim previousConnectionState As ConnectionState = conn.State
            Try
                If conn.State = ConnectionState.Closed Then
                    conn.Open()
                End If
                result = cmd.ExecuteScalar()

            Finally
                If previousConnectionState = ConnectionState.Closed Then
                    conn.Close()
                End If
            End Try

            Return "upload/" & result

        Catch ex As Exception

            Throw (ex)

        End Try

    End Function


End Class
